/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.rendimiento.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ModeloValoresRetenido
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String>> tiposIdentificacion = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private static Map<String, ElementoNombreValor<String>> paises = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposPago = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposDeRetenido = new LinkedHashMap<String, ElementoNombreValor<String>>();

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposIdentificacion();
            this.cargarPaises();
            this.cargarPagos();
            this.cargarTiposDeRetenido();
            this.inicializado = true;
        }
    }

    private void cargarTiposIdentificacion() {
        this.tiposIdentificacion.clear();
        this.tiposIdentificacion.put("R", (ElementoNombreValor<String>)new ElementoNombreValor("RUC", (Object)"R"));
        this.tiposIdentificacion.put("C", (ElementoNombreValor<String>)new ElementoNombreValor("CEDULA", (Object)"C"));
        this.tiposIdentificacion.put("P", (ElementoNombreValor<String>)new ElementoNombreValor("PASAPORTE/IDENTIFICACION TRIBUTARIA DEL EXTERIOR", (Object)"P"));
    }

    private void cargarTiposDeRetenido() {
        this.tiposDeRetenido.clear();
        Map tiposConsultados = UtilCatalogosATS.crearInstancia().obtenerTiposDeContribuyente();
        for (Map.Entry tipoContribuyente : tiposConsultados.entrySet()) {
            this.tiposDeRetenido.put((String)tipoContribuyente.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)tipoContribuyente.getValue(), (Object)((String)tipoContribuyente.getKey())));
        }
    }

    private void cargarPaises() {
        paises.clear();
        TreeSet<ElementoNombreValor<String>> oPaises = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        Map cPaises = UtilCatalogosATS.crearInstancia().obtenerPaises();
        for (Map.Entry entry : cPaises.entrySet()) {
            if ("593".equals(entry.getKey())) continue;
            oPaises.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
        }
        for (ElementoNombreValor elementoNombreValor : oPaises) {
            paises.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
        }
    }

    private void cargarPagos() {
        this.tiposPago.clear();
        this.tiposPago.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("PAGO A RESIDENTE / ESTABLECIMIENTO PERMANENTE", (Object)"01"));
        this.tiposPago.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("PAGO A NO RESIDENTE", (Object)"02"));
    }

    public List<ElementoNombreValor<String>> getTiposPagos() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposPago.values());
    }

    public ElementoNombreValor<String> obtenerTipoPago(String tipoPago) {
        return StringUtil.isNullOrEmpty((String)tipoPago) ? null : this.tiposPago.get(tipoPago);
    }

    public List<ElementoNombreValor<String>> getTiposDeRetenido() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposDeRetenido.values());
    }

    public ElementoNombreValor<String> obtenerTipoDeRetenido(String codigoTipoRetenido) {
        return StringUtil.isNullOrEmpty((String)codigoTipoRetenido) ? null : this.tiposDeRetenido.get(codigoTipoRetenido);
    }

    public List<ElementoNombreValor<String>> getTiposIdentificacion() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposIdentificacion.values());
    }

    public ElementoNombreValor<String> obtenerTipoIdentificacion(String tipoIdentificacion) {
        return StringUtil.isNullOrEmpty((String)tipoIdentificacion) ? null : this.tiposIdentificacion.get(tipoIdentificacion);
    }

    public List<ElementoNombreValor<String>> getPaises() {
        return new ArrayList<ElementoNombreValor<String>>(paises.values());
    }

    private Comparator<ElementoNombreValor<String>> getComparadorElementoNombreValor() {
        return new Comparator<ElementoNombreValor<String>>(){

            @Override
            public int compare(ElementoNombreValor<String> e1, ElementoNombreValor<String> e2) {
                return e1.getEtiqueta().compareTo(e2.getEtiqueta());
            }
        };
    }

    public ElementoNombreValor<String> obtenerPais(String pais) {
        return StringUtil.isNullOrEmpty((String)pais) ? null : paises.get(pais);
    }
}

